package com.biz.crm.member.business.member.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoReceiptRecordDetailVo;
import com.biz.crm.member.business.member.local.entity.MemberInfoReceiptRecordDetail;
import com.biz.crm.member.business.member.local.mapper.MemberInfoReceiptRecordDetailMapper;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoReceiptRecordDetailPaginationDto;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 会员签收记录产品明细(repository)
 *
 * @author zouhs
 * @date 2023-06-28 16:55:58
 */
@Component
public class MemberInfoReceiptRecordDetailRepository extends ServiceImpl<MemberInfoReceiptRecordDetailMapper, MemberInfoReceiptRecordDetail> {
  
  /**
   * 分页
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<MemberInfoReceiptRecordDetailVo> findByConditions(Page<MemberInfoReceiptRecordDetailVo> page, MemberInfoReceiptRecordDetailPaginationDto dto) {
    return this.baseMapper.findByConditions(page, dto);
  }
  
  public MemberInfoReceiptRecordDetail findById(String id) {
    return this.baseMapper.selectById(id);
  }

  /**
   * 根据id集合获取详情集合
   *
   * @param ids
   * @return
   */
  public List<MemberInfoReceiptRecordDetail> findByIds(List<String> ids) {
    return this.lambdaQuery().in(MemberInfoReceiptRecordDetail::getId, ids).list();
  }

  /**
   * 根据id集合 更新组织启用/禁用状态
   *
   * @param ids
   * @param enable
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
    this.lambdaUpdate()
        .in(MemberInfoReceiptRecordDetail::getId, ids)
        .set(MemberInfoReceiptRecordDetail::getEnableStatus, enable.getCode())
        .update();
  }

  /**
   * 逻辑删除
   *
   * @param ids
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(MemberInfoReceiptRecordDetail::getId, ids)
        .set(MemberInfoReceiptRecordDetail::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }
}
