package com.biz.crm.member.business.member.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoReceiptRecordVo;
import com.biz.crm.member.business.member.local.entity.MemberInfoReceiptRecord;
import com.biz.crm.member.business.member.local.mapper.MemberInfoReceiptRecordMapper;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoReceiptRecordPaginationDto;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 会员签收记录(repository)
 *
 * @author zouhs
 * @date 2023-06-28 16:55:36
 */
@Component
public class MemberInfoReceiptRecordRepository extends ServiceImpl<MemberInfoReceiptRecordMapper, MemberInfoReceiptRecord> {
  
  /**
   * 分页
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<MemberInfoReceiptRecordVo> findByConditions(Page<MemberInfoReceiptRecordVo> page, MemberInfoReceiptRecordPaginationDto dto) {
    return this.baseMapper.findByConditions(page, dto);
  }
  
  public MemberInfoReceiptRecord findById(String id) {
    return this.baseMapper.selectById(id);
  }

  /**
   * 根据id集合获取详情集合
   *
   * @param ids
   * @return
   */
  public List<MemberInfoReceiptRecord> findByIds(List<String> ids) {
    return this.lambdaQuery().in(MemberInfoReceiptRecord::getId, ids).list();
  }

  /**
   * 根据id集合 更新组织启用/禁用状态
   *
   * @param ids
   * @param enable
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
    this.lambdaUpdate()
        .in(MemberInfoReceiptRecord::getId, ids)
        .set(MemberInfoReceiptRecord::getEnableStatus, enable.getCode())
        .update();
  }

  /**
   * 逻辑删除
   *
   * @param ids
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(MemberInfoReceiptRecord::getId, ids)
        .set(MemberInfoReceiptRecord::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }
}
