package com.biz.crm.member.business.member.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoVo;
import com.biz.crm.member.business.member.local.entity.MemberInfo;
import com.biz.crm.member.business.member.local.mapper.MemberInfoMapper;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoPaginationDto;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 会员信息(repository)
 *
 * @author zouhs
 * @date 2023-06-19 14:31:57
 */
@Component
public class MemberInfoRepository extends ServiceImpl<MemberInfoMapper, MemberInfo> {
  
  /**
   * 分页
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<MemberInfoVo> findByConditions(Page<MemberInfoVo> page, MemberInfoPaginationDto dto) {
    return this.baseMapper.findByConditions(page, dto);
  }
  
  public MemberInfo findById(String id) {
    return this.baseMapper.selectById(id);
  }

  /**
   * 根据id集合获取详情集合
   *
   * @param ids
   * @return
   */
  public List<MemberInfo> findByIds(List<String> ids) {
    return this.lambdaQuery().in(MemberInfo::getId, ids).list();
  }

  /**
   * 根据id集合 更新组织启用/禁用状态
   *
   * @param ids
   * @param enable
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
    this.lambdaUpdate()
        .in(MemberInfo::getId, ids)
        .set(MemberInfo::getEnableStatus, enable.getCode())
        .update();
  }

  /**
   * 逻辑删除
   *
   * @param ids
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(MemberInfo::getId, ids)
        .set(MemberInfo::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }
}
