package com.biz.crm.member.business.member.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoSupplyVo;
import com.biz.crm.member.business.member.local.entity.MemberInfoSupply;
import com.biz.crm.member.business.member.local.mapper.MemberInfoSupplyMapper;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoSupplyPaginationDto;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 采供关系(repository)
 *
 * @author zouhs
 * @date 2023-06-19 14:34:41
 */
@Component
public class MemberInfoSupplyRepository extends ServiceImpl<MemberInfoSupplyMapper, MemberInfoSupply> {
  
  /**
   * 分页
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<MemberInfoSupplyVo> findByConditions(Page<MemberInfoSupplyVo> page, MemberInfoSupplyPaginationDto dto) {
    return this.baseMapper.findByConditions(page, dto);
  }
  
  public MemberInfoSupply findById(String id) {
    return this.baseMapper.selectById(id);
  }

  /**
   * 根据id集合获取详情集合
   *
   * @param ids
   * @return
   */
  public List<MemberInfoSupply> findByIds(List<String> ids) {
    return this.lambdaQuery().in(MemberInfoSupply::getId, ids).list();
  }

  /**
   * 根据id集合 更新组织启用/禁用状态
   *
   * @param ids
   * @param enable
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
    this.lambdaUpdate()
        .in(MemberInfoSupply::getId, ids)
        .set(MemberInfoSupply::getEnableStatus, enable.getCode())
        .update();
  }

  /**
   * 逻辑删除
   *
   * @param ids
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(MemberInfoSupply::getId, ids)
        .set(MemberInfoSupply::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }
}
