package com.biz.crm.member.business.member.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoTagVo;
import com.biz.crm.member.business.member.local.entity.MemberInfoTag;
import com.biz.crm.member.business.member.local.mapper.MemberInfoTagMapper;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoTagPaginationDto;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 会员标签(repository)
 *
 * @author zouhs
 * @date 2023-06-19 14:35:01
 */
@Component
public class MemberInfoTagRepository extends ServiceImpl<MemberInfoTagMapper, MemberInfoTag> {
  
  /**
   * 分页
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<MemberInfoTagVo> findByConditions(Page<MemberInfoTagVo> page, MemberInfoTagPaginationDto dto) {
    return this.baseMapper.findByConditions(page, dto);
  }
  
  public MemberInfoTag findById(String id) {
    return this.baseMapper.selectById(id);
  }

  /**
   * 根据id集合获取详情集合
   *
   * @param ids
   * @return
   */
  public List<MemberInfoTag> findByIds(List<String> ids) {
    return this.lambdaQuery().in(MemberInfoTag::getId, ids).list();
  }

  /**
   * 根据id集合 更新组织启用/禁用状态
   *
   * @param ids
   * @param enable
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
    this.lambdaUpdate()
        .in(MemberInfoTag::getId, ids)
        .set(MemberInfoTag::getEnableStatus, enable.getCode())
        .update();
  }

  /**
   * 逻辑删除
   *
   * @param ids
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(MemberInfoTag::getId, ids)
        .set(MemberInfoTag::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }
}
