package com.biz.crm.member.business.member.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.member.business.member.local.entity.ProductCategory;
import com.biz.crm.member.business.member.local.mapper.ProductCategoryMapper;
import com.biz.crm.member.business.member.sdk.dto.ProductCategoryDto;
import com.biz.crm.member.business.member.sdk.vo.ProductCategoryVo;
import com.biz.crm.member.business.member.sdk.vo.ProductPageVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 商品分类repository 持久层
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/14 16:31
 **/
@Component
public class ProductCategoryRepository extends ServiceImpl<ProductCategoryMapper, ProductCategory> {

    @Autowired
    private ProductCategoryMapper productCategoryMapper;

    public Page<ProductCategoryVo> findByConditions(Page<ProductPageVo> page, ProductCategoryDto productCategoryDto) {

        return this.productCategoryMapper.findByConditions(page,productCategoryDto);

    }

    public void down(String id) {

        this.productCategoryMapper.down(id);
    }

    public void up(String id) {
        this.productCategoryMapper.up(id);
    }
}
