package com.biz.crm.member.business.member.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.member.business.member.local.entity.AppPointExchangeEntity;
import com.biz.crm.member.business.member.local.entity.Product;
import com.biz.crm.member.business.member.local.mapper.ProductMapper;
import com.biz.crm.member.business.member.sdk.dto.AppPointStoreDto;
import com.biz.crm.member.business.member.sdk.dto.ProductPageDto;
import com.biz.crm.member.business.member.sdk.vo.ProductPageVo;
import com.biz.crm.member.business.member.sdk.vo.ProductVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 商品repository
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/13 16:51
 **/
@Component
public class ProductRepository extends ServiceImpl<ProductMapper, Product> {

    @Autowired
    private ProductMapper productMapper;

    public Page<ProductPageVo> findByConditions(Page<ProductPageVo> page, ProductPageDto productPageDto) {
        return productMapper.findByConditions(page,productPageDto);
    }

    public Page<ProductPageVo> findByConditionsByApplet(Page<ProductPageVo> page, ProductPageDto productPageDto) {
        return productMapper.findByConditionsByApplet(page,productPageDto);
    }

    public ProductVo findAppletDetailById(String id) {
        return productMapper.findAppletDetailById(id);
    }

    public AppPointExchangeEntity findAvailableCount(AppPointStoreDto dto) {
        return productMapper.findAvailableCount(dto);
    }
}
