package com.biz.crm.member.business.member.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.member.business.member.local.entity.QuestionnaireQuestion;
import com.biz.crm.member.business.member.local.mapper.QuestionnaireQuestionMapper;
import com.biz.crm.member.business.member.sdk.vo.QuestionCountVo;
import com.biz.crm.member.business.member.sdk.vo.QuestionVo;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/20 15:35
 * @description 问卷题目配置(repository)
 */
@Component
public class QuestionnaireQuestionRepository extends ServiceImpl<QuestionnaireQuestionMapper, QuestionnaireQuestion> {


  /**
   * 根据问卷编码获取题目配置信息
   * 根据sortIndex升序排序
   * @param questionnaireCode
   * @return
   */
  public List<QuestionVo> listByQuestionnaireCodeOrderBySortIndex(String questionnaireCode) {
    return this.baseMapper.listByQuestionnaireCodeOrderBySortIndex(questionnaireCode,
        DelFlagStatusEnum.NORMAL.getCode());
  }


  /**
   * 根据问卷编码逻辑删除题目
   * @param questionnaireCode
   */
  public void logicDeleteByQuestionnaireCode(String questionnaireCode) {
    this.lambdaUpdate()
        .set(QuestionnaireQuestion::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .eq(QuestionnaireQuestion::getQuestionnaireCode, questionnaireCode)
        .update();
  }
}
