package com.biz.crm.member.business.member.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.sdk.dto.AppOrderPaginationDto;
import com.biz.crm.member.business.member.sdk.dto.RealAndDummyOrderPaginationDto;
import com.biz.crm.member.business.member.sdk.enums.RealOrderStatusEnum;
import com.biz.crm.member.business.member.sdk.enums.RealOrderTypeEnum;
import com.biz.crm.member.business.member.sdk.vo.RealAndDummyOrderVo;
import com.biz.crm.member.business.member.sdk.vo.RealOrderVo;
import com.biz.crm.member.business.member.local.entity.RealOrder;
import com.biz.crm.member.business.member.local.mapper.RealOrderMapper;
import com.biz.crm.member.business.member.sdk.dto.RealOrderPaginationDto;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 实物订单(repository)
 *
 * @author zouhs
 * @date 2023-06-14 14:53:17
 */
@Component
public class RealOrderRepository extends ServiceImpl<RealOrderMapper, RealOrder> {
  
  /**
   * 分页
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<RealOrderVo> findByConditions(Page<RealOrderVo> page, RealOrderPaginationDto dto) {
    return this.baseMapper.findByConditions(page, dto);
  }
  
  public RealOrder findById(String id) {
    return this.baseMapper.selectById(id);
  }

  /**
   * 根据id集合获取详情集合
   *
   * @param ids
   * @return
   */
  public List<RealOrder> findByIds(List<String> ids) {
    return this.lambdaQuery().in(RealOrder::getId, ids).list();
  }

  /**
   * 根据id集合 更新组织启用/禁用状态
   *
   * @param ids
   * @param enable
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
    this.lambdaUpdate()
        .in(RealOrder::getId, ids)
        .set(RealOrder::getEnableStatus, enable.getCode())
        .update();
  }

  /**
   * 逻辑删除
   *
   * @param ids
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(RealOrder::getId, ids)
        .set(RealOrder::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }

  public void changeTotalOrder(List<String> ids) {
    this.lambdaUpdate()
        .in(RealOrder::getId, ids)
        .eq(RealOrder::getOrderType, RealOrderTypeEnum.MARKET_ORDER.getValue())
        .set(RealOrder::getOrderType, RealOrderTypeEnum.TOTAL_ORDER.getValue())
        .set(RealOrder::getOrderStatus, RealOrderStatusEnum.STAY_SHIP.getValue())
        .update();
  }

  public void changeMarketOrder(List<String> ids) {
    this.lambdaUpdate()
        .in(RealOrder::getId, ids)
        .eq(RealOrder::getOrderType, RealOrderTypeEnum.TOTAL_ORDER.getValue())
        .set(RealOrder::getOrderType, RealOrderTypeEnum.MARKET_ORDER.getValue())
        .set(RealOrder::getOrderStatus, RealOrderStatusEnum.STAY_DELIVERY.getValue())
        .update();
  }

  /**
   * 小程序个人中心分页获取真实订单
   * @param page
   * @param dto
   * @param memberCode
   * @return
   */
  public Page<RealOrderVo> appPageRealOrder(Page<RealOrderVo> page, AppOrderPaginationDto dto, String memberCode) {
    return this.baseMapper.appPageRealOrder(page, dto, memberCode, DelFlagStatusEnum.NORMAL.getCode());
  }

  /**
   * 小程序个人中心分页获取实物订单根据salesmanCode和orderStatus
   * @param page
   * @param orderStatus
   * @param salesmanCode
   * @return
   */
  public Page<RealOrderVo> appPageRealOrderBySalesmanCode(Page<RealOrderVo> page, String orderStatus, String salesmanCode) {
    return this.baseMapper.appPageRealOrderBySalesmanCode(page,
        orderStatus,
        salesmanCode,
        DelFlagStatusEnum.NORMAL.getCode());
  }

  /**
   * 小程序分页获取指定组织编码的分发订单
   * @param page
   * @param orderStatus
   * @param orgCode
   * @return
   */
  public Page<RealOrderVo> appPageDispatchOrder(Page<RealOrderVo> page, String orderStatus, String orgCode) {
    return this.baseMapper.appPageDispatchOrder(page,
        orderStatus,
        orgCode,
        DelFlagStatusEnum.NORMAL.getCode());
  }

  public Page<RealAndDummyOrderVo> findByConditionsRealAndOrder(Page<RealAndDummyOrderVo> page, RealAndDummyOrderPaginationDto dto) {
    return this.baseMapper.findByConditionsRealAndOrder(page, dto);
  }
}
