package com.biz.crm.member.business.member.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.local.entity.BenefitsManage;
import com.biz.crm.member.business.member.local.entity.RealOrder;
import com.biz.crm.member.business.member.local.entity.ScenicAreaManagement;
import com.biz.crm.member.business.member.local.mapper.RealOrderMapper;
import com.biz.crm.member.business.member.local.mapper.ScenicAreaManagementMapper;
import com.biz.crm.member.business.member.sdk.dto.BenefitsManagePaginationDto;
import com.biz.crm.member.business.member.sdk.dto.ScenicAreaManagementPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.BenefitsManageVo;
import com.biz.crm.member.business.member.sdk.vo.ScenicAreaManagementVo;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * @author hupan
 * @date 2023/6/20 10:55
 */
@Component
public class ScenicAreaManagementRepository extends ServiceImpl<ScenicAreaManagementMapper, ScenicAreaManagement> {

  /**
   * 分页
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<ScenicAreaManagementVo> findByConditions(Page<ScenicAreaManagementVo> page, ScenicAreaManagementPaginationDto dto) {
    return this.baseMapper.findByConditions(page, dto);
  }

  /**
   * 根据id集合获取详情集合
   *
   * @param id
   * @return
   */
  public ScenicAreaManagement findById(String id) {
    return this.baseMapper.selectById(id);
  }

  /**
   * 根据id集合 更新组织启用/禁用状态
   *
   * @param ids
   * @param enable
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
    this.lambdaUpdate()
        .in(ScenicAreaManagement::getId, ids)
        .set(ScenicAreaManagement::getEnableStatus, enable.getCode())
        .update();
  }

  /**
   * 逻辑删除
   *
   * @param ids
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(ScenicAreaManagement::getId, ids)
        .set(ScenicAreaManagement::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }
}
