package com.biz.crm.member.business.member.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.sdk.vo.SignInRuleDetailVo;
import com.biz.crm.member.business.member.local.entity.SignInRuleDetail;
import com.biz.crm.member.business.member.local.mapper.SignInRuleDetailMapper;
import com.biz.crm.member.business.member.sdk.dto.SignInRuleDetailPaginationDto;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 签到规则明细(repository)
 *
 * @author zouhs
 * @date 2023-06-15 16:47:45
 */
@Component
public class SignInRuleDetailRepository extends ServiceImpl<SignInRuleDetailMapper, SignInRuleDetail> {

  /**
   * 分页
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<SignInRuleDetailVo> findByConditions(Page<SignInRuleDetailVo> page, SignInRuleDetailPaginationDto dto) {
    return this.baseMapper.findByConditions(page, dto);
  }
  
  public SignInRuleDetail findById(String id) {
    return this.baseMapper.selectById(id);
  }

  /**
   * 根据id集合获取详情集合
   *
   * @param ids
   * @return
   */
  public List<SignInRuleDetail> findByIds(List<String> ids) {
    return this.lambdaQuery().in(SignInRuleDetail::getId, ids).list();
  }

  /**
   * 根据id集合 更新组织启用/禁用状态
   *
   * @param ids
   * @param enable
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
    this.lambdaUpdate()
        .in(SignInRuleDetail::getId, ids)
        .set(SignInRuleDetail::getEnableStatus, enable.getCode())
        .update();
  }

  /**
   * 逻辑删除
   *
   * @param ids
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(SignInRuleDetail::getId, ids)
        .set(SignInRuleDetail::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }
}
