package com.biz.crm.member.business.member.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.sdk.vo.SignInRuleVo;
import com.biz.crm.member.business.member.local.entity.SignInRule;
import com.biz.crm.member.business.member.local.mapper.SignInRuleMapper;
import com.biz.crm.member.business.member.sdk.dto.SignInRulePaginationDto;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 签到规则(repository)
 *
 * @author zouhs
 * @date 2023-06-15 16:47:20
 */
@Component
public class SignInRuleRepository extends ServiceImpl<SignInRuleMapper, SignInRule> {
  
  /**
   * 分页
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<SignInRuleVo> findByConditions(Page<SignInRuleVo> page, SignInRulePaginationDto dto) {
    return this.baseMapper.findByConditions(page, dto);
  }
  
  public SignInRule findById(String id) {
    return this.baseMapper.selectById(id);
  }

  /**
   * 根据id集合获取详情集合
   *
   * @param ids
   * @return
   */
  public List<SignInRule> findByIds(List<String> ids) {
    return this.lambdaQuery().in(SignInRule::getId, ids).list();
  }

  /**
   * 根据id集合 更新组织启用/禁用状态
   *
   * @param ids
   * @param enable
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
    this.lambdaUpdate()
        .in(SignInRule::getId, ids)
        .set(SignInRule::getEnableStatus, enable.getCode())
        .update();
  }

  /**
   * 逻辑删除
   *
   * @param ids
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(SignInRule::getId, ids)
        .set(SignInRule::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }
}
