package com.biz.crm.member.business.member.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.member.business.member.local.entity.TastingConsultant;
import com.biz.crm.member.business.member.local.mapper.TastingConsultantMapper;
import com.biz.crm.member.business.member.sdk.dto.TastingConsultantPageDto;
import com.biz.crm.member.business.member.sdk.vo.IndustryPageVo;
import com.biz.crm.member.business.member.sdk.vo.TastingConsultantPageVo;
import com.biz.crm.member.business.member.sdk.vo.TastingConsultantVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 品鉴顾问repository
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/13 10:58
 **/
@Component
public class TastingConsultantRepository extends ServiceImpl<TastingConsultantMapper, TastingConsultant> {

    @Autowired
    private TastingConsultantMapper tastingConsultantMapper;

    public Page<TastingConsultantPageVo> findByConditions(Page<TastingConsultantPageVo> page, TastingConsultantPageDto tastingConsultantPageDto) {
        return this.tastingConsultantMapper.findByConditions(page,tastingConsultantPageDto);
    }

  public TastingConsultantVo queryFlagTastingByPhone(String memberPhone) {
      return this.tastingConsultantMapper.queryFlagTastingByPhone(memberPhone);
  }
}
