package com.biz.crm.member.business.member.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.dto.AddressManagePaginationDto;
import com.biz.crm.member.business.member.sdk.dto.BenefitsManagePaginationDto;
import com.biz.crm.member.business.member.sdk.vo.AddressManageVo;
import com.biz.crm.member.business.member.sdk.vo.BenefitsManageVo;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * @author hupan
 * @date 2023/6/30 13:34
 */
public interface AddressManageService {

  /**
   * 按照memberCode分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<AddressManageVo> findByConditions(Pageable pageable, AddressManagePaginationDto dto);

  /**
   * 创建
   *
   * @param addressManageVo
   * @return
   */
  AddressManageVo create(AddressManageVo addressManageVo);

  /**
   * 更新
   *
   * @param addressManageVo
   * @return
   */
  AddressManageVo update(AddressManageVo addressManageVo);

  /**
   * 根据地址id查询详情
   * @param id
   */
  AddressManageVo findDetailById(String id);
  /**
   * 设置为默认地址
   *
   * @param id
   * @return
   */
  void setDefault(String id);

  /**
   * 批量删除
   *
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);

  /**
   * 逻辑删除
   *
   * @param id
   */
  void updateDelFlagById(String id);

}
