package com.biz.crm.member.business.member.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.local.entity.AnswerRecord;
import com.biz.crm.member.business.member.sdk.dto.AnswerRecordPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.AnswerRecordVo;
import com.biz.crm.member.business.member.sdk.vo.QuestionCountVo;
import com.biz.crm.member.business.member.sdk.vo.QuestionStatisticVo;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/21 15:16
 * @description 用户答题记录管理
 */
public interface AnswerRecordService {

  /**
   * 统计题目答案个数
   * @param questionCodes
   * @return
   */
  List<QuestionStatisticVo> statisticQuestion(List<String> questionCodes);

  /**
   * 根据题目编码分页获取答题记录
   * @param pageable
   * @param dto
   * @return
   */
  Page<AnswerRecordVo> pageAnswerRecord(Pageable pageable, AnswerRecordPaginationDto dto);

  /**
   * 根据题目编号和目标用户账号获取答题记录
   * @param questionCodes
   * @return
   */
  List<AnswerRecordVo> getByQuestionCodes(List<String> questionCodes, String memberCode);

  /**
   * 根据题目编码获取答题记录
   * @param questionCodes
   * @return
   */
  List<AnswerRecord> listAnswerRecord(List<String> questionCodes);

  /**
   * 批量新增答题记录
   * @param answerRecords
   */
  void batchSave(List<AnswerRecord> answerRecords);
}
