package com.biz.crm.member.business.member.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.local.entity.BenefitsManageOrg;
import com.biz.crm.member.business.member.sdk.vo.BenefitsManageOrgVo;
import com.biz.crm.member.business.member.sdk.dto.BenefitsManageOrgPaginationDto;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * 权益管理-区域有效期配置(BenefitsManageOrg)表服务接口
 *
 * @author zouhs
 * @date 2023-06-12 12:39:28
 */
public interface BenefitsManageOrgService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<BenefitsManageOrgVo> findByConditions(Pageable pageable, BenefitsManageOrgPaginationDto dto);

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  BenefitsManageOrgVo findDetailById(String id);

  /**
   * 创建
   *
   * @param benefitsManageOrgVo
   * @return
   */
  BenefitsManageOrgVo create(BenefitsManageOrgVo benefitsManageOrgVo);

  /**
   * 更新
   *
   * @param benefitsManageOrgVo
   * @return
   */
  BenefitsManageOrgVo update(BenefitsManageOrgVo benefitsManageOrgVo);

  /**
   * 按id集合启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 按id集合禁用
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 逻辑删除
   *
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);

  /**
   * 批量新增
   * @param list
   */
  void saveBatch(List<BenefitsManageOrgVo> list);

  /**
   * 查询权益管理相关区域有效配置
   * @param id
   * @return
   */
  List<BenefitsManageOrg> findListByBenefitsManageId(String id);

  /**
   * 查询权益管理相关区域有效配置
   * @param id
   * @return
   */
  List<BenefitsManageOrgVo> findListVoByBenefitsManageId(String id);
}
