package com.biz.crm.member.business.member.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.vo.BenefitsManageVo;
import com.biz.crm.member.business.member.sdk.dto.BenefitsManagePaginationDto;
import java.util.List;
import java.util.Set;
import org.springframework.data.domain.Pageable;

/**
 * 权益管理(BenefitsManage)表服务接口
 *
 * @author zouhs
 * @date 2023-06-12 12:29:46
 */
public interface BenefitsManageService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<BenefitsManageVo> findByConditions(Pageable pageable, BenefitsManagePaginationDto dto);

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  BenefitsManageVo findDetailById(String id);

  /**
   * 创建
   *
   * @param benefitsManageVo
   * @return
   */
  BenefitsManageVo create(BenefitsManageVo benefitsManageVo);

  /**
   * 更新
   *
   * @param benefitsManageVo
   * @return
   */
  BenefitsManageVo update(BenefitsManageVo benefitsManageVo);

  /**
   * 按id集合启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 按id集合禁用
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 逻辑删除
   *
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);

  /**
   *
   * @param benefitsCodes
   * @return
   */
  List<BenefitsManageVo> findDetailByCodes(Set<String> benefitsCodes);
}
