package com.biz.crm.member.business.member.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.dto.ChoiceNessCategoryDto;
import com.biz.crm.member.business.member.sdk.dto.ChoiceNessCategoryPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.ChoiceNessCategoryVo;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/16 17:06
 * @description 精选分类管理
 */
public interface ChoiceNessCategoryService {

  /**
   * 新增精选分类
   * @param dto
   * @return
   */
  ChoiceNessCategoryVo createChoiceNessCategory(ChoiceNessCategoryDto dto);

  /**
   * 修改精选分类
   * @param dto
   * @return
   */
  ChoiceNessCategoryVo updateChoiceNessCategory(ChoiceNessCategoryDto dto);

  /**
   * 根据id获取单个精选分类信息
   * @param id
   * @return
   */
  ChoiceNessCategoryVo getChoiceNessCategoryById(String id);

  /**
   * 分页获取精选分类信息
   * @param pageable
   * @param dto
   * @return
   */
  Page<ChoiceNessCategoryVo> pageChoiceNessCategory(Pageable pageable, ChoiceNessCategoryPaginationDto dto);

  /**
   * 根据id集合批量修改状态为启用
   * @param ids
   */
  void turnOnCategory(List<String> ids);

  /**
   * 根据id集合批量修改状态为禁用
   * @param ids
   */
  void turnOffCategory(List<String> ids);

  /**
   * 根据id批量逻辑删除精选分类
   * @param ids
   */
  void logicDeleteCategory(List<String> ids);

  /**
   * 小程序端获取有效的精选分类
   * @return
   */
  List<ChoiceNessCategoryVo> appListEnableChoiceNessCategory();
}
