package com.biz.crm.member.business.member.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.dto.CulturalAndTourismRespondentPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.CulturalAndTourismInitAPIVo;
import com.biz.crm.member.business.member.sdk.vo.CulturalAndTourismRespondentAPIVo;
import com.biz.crm.member.business.member.sdk.vo.CulturalAndTourismRespondentVo;
import com.biz.crm.member.business.member.sdk.vo.SystemSettingsDetailVo;
import org.springframework.data.domain.Pageable;

/**
 * 文旅答题答题记录服务层接口
 *
 * @author hupan
 * @date 2023/6/19 14:42
 */
public interface CulturalAndTourismRespondentService {


  /**
   * 分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<CulturalAndTourismRespondentVo> findByConditions(Pageable pageable, CulturalAndTourismRespondentPaginationDto dto);

  /**
   * 创建
   *
   * @param phone
   * @return
   */
  CulturalAndTourismInitAPIVo initData(String phone);

  /**
   * 创建
   *
   * @param culturalAndTourismRespondentAPIVo
   * @return
   */
  CulturalAndTourismRespondentAPIVo create(CulturalAndTourismRespondentAPIVo culturalAndTourismRespondentAPIVo);

  /**
   * 已答题
   *
   * @param phone
   * @return
   */
  Integer count(String phone);

  /**
   * 答题获得积分
   *
   * @param phone
   * @return
   */
  Integer earnPoints(String phone);

  /**
   * 本月还可获得积分答题次数
   *
   * @param phone
   * @return
   */
  Integer numberOfQuestionsLeftThisMonth(String phone);


  /**
   * 答题规则
   *
   * @param
   * @return
   */
  SystemSettingsDetailVo activityRules();
}
