package com.biz.crm.member.business.member.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.dto.BenefitsManagePaginationDto;
import com.biz.crm.member.business.member.sdk.dto.CulturalAndTourismTopicPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.BenefitsManageVo;
import com.biz.crm.member.business.member.sdk.vo.CulturalAndTourismTopicAPIVo;
import com.biz.crm.member.business.member.sdk.vo.CulturalAndTourismTopicVo;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * 文旅答题题目管理服务层接口
 *
 * @author hupan
 * @date 2023/6/19 13:36
 */
public interface CulturalAndTourismTopicService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<CulturalAndTourismTopicVo> findByConditions(Pageable pageable, CulturalAndTourismTopicPaginationDto dto);

  /**
   * 创建
   *
   * @param culturalAndTourismTopicVo
   * @return
   */
  CulturalAndTourismTopicVo create(CulturalAndTourismTopicVo culturalAndTourismTopicVo);

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  CulturalAndTourismTopicVo findDetailById(String id);

  /**
   * 更新
   *
   * @param culturalAndTourismTopicVo
   * @return
   */
  CulturalAndTourismTopicVo update(CulturalAndTourismTopicVo culturalAndTourismTopicVo);

  /**
   * 按id集合启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 按id集合禁用
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 逻辑删除
   *
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);

  CulturalAndTourismTopicAPIVo questionTopic();
}
