package com.biz.crm.member.business.member.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.dto.DiscussDto;
import com.biz.crm.member.business.member.sdk.dto.DiscussPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.DiscussVo;
import com.biz.crm.member.business.member.sdk.vo.InfoCountDto;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/19 14:07
 * @description 评论管理
 */
public interface DiscussService {

  /**
   * 新增一个评论
   * @param dto
   * @return
   */
  DiscussVo createDiscuss(DiscussDto dto);

  /**
   * 批量逻辑删除评论
   * @param ids
   */
  void logicDeleteByIds(List<String> ids);

  /**
   * 批量操作审核状态
   * @param ids 所需修改的id集合
   * @param checkStatus 审核状态编码
   */
  void batchModifyCheckStatus(List<String> ids, String checkStatus);

  /**
   * 批量启用状态
   * @param ids
   */
  void turnOnDiscuss(List<String> ids);

  /**
   * 批量禁用
   * @param ids
   */
  void turnOffDiscuss(List<String> ids);

  /**
   * 批量精选评论
   * @param ids
   */
  void batchModifyChoiceDiscuss(List<String> ids, Integer choiceDiscuss);

  /**
   * 分页获取评论信息
   * @param pageable
   * @param dto
   * @return
   */
  Page<DiscussVo> pageDiscuss(Pageable pageable, DiscussPaginationDto dto);

  /**
   * 分组统计评论数量
   * @param infoCodes
   * @return
   */
  List<InfoCountDto> countByInfoCodes(List<String> infoCodes,  String checkStatus, String enableStatus);

  /**
   * 小程序分页获取资讯评论信息
   * @param pageable
   * @param infoCode
   * @return
   */
  Page<DiscussVo> appPageDiscussByInfoCode(Pageable pageable, String infoCode);

  /**
   * 判断当前用户是否可以评论
   * @return
   */
  Boolean enableDiscuss();

  /**
   * 小程序获取属于自己的前3条已通过审批的评论
   * @param infoCode
   * @return
   */
  List<DiscussVo> appListOwnerDiscussLimit(String infoCode);
}
