package com.biz.crm.member.business.member.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.dto.AppOrderPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.DummyOrderUserVo;
import com.biz.crm.member.business.member.sdk.vo.DummyOrderVo;
import com.biz.crm.member.business.member.sdk.dto.DummyOrderPaginationDto;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * 虚拟订单(DummyOrder)表服务接口
 *
 * @author zouhs
 * @date 2023-06-14 15:00:59
 */
public interface DummyOrderService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<DummyOrderVo> findByConditions(Pageable pageable, DummyOrderPaginationDto dto);

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  DummyOrderVo findDetailById(String id);

  /**
   * 创建
   *
   * @param dummyOrderVo
   * @return
   */
  DummyOrderVo create(DummyOrderVo dummyOrderVo);

  /**
   * 更新
   *
   * @param dummyOrderVo
   * @return
   */
  DummyOrderVo update(DummyOrderVo dummyOrderVo);

  /**
   * 按id集合启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 按id集合禁用
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 逻辑删除
   *
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);

  /**
   * 用户信息
   * @param orderCode
   * @return
   */
  List<DummyOrderUserVo> userInfoList(String orderCode);

  /**
   * 批量核销
   * @param ids
   */
  void batchWriteOff(List<String> ids);

  /**
   * 结算-提交工作流
   * @param dummyOrderVo
   */
  void settleSubmit(DummyOrderVo dummyOrderVo);

  /**
   * 小程序分页获取虚拟订单
   * @param pageable
   * @param dto
   * @return
   */
  Page<DummyOrderVo> appPageDummyOrder(Pageable pageable, AppOrderPaginationDto dto);

  /**
   * 根据虚拟订单Id核销虚拟订单
   * @param dummyOrderId
   */
  void writeDummyOrderById(String dummyOrderId);

  /**
   * 订单号
   * @param orderCode
   * @return
   */
  DummyOrderVo findDetailByOrderCode(String orderCode);
}
