package com.biz.crm.member.business.member.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.vo.DummyOrderApplyUserVo;
import com.biz.crm.member.business.member.sdk.vo.DummyOrderUserVo;
import com.biz.crm.member.business.member.sdk.dto.DummyOrderUserPaginationDto;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * 虚拟订单用户信息(DummyOrderUser)表服务接口
 *
 * @author zouhs
 * @date 2023-06-14 15:01:25
 */
public interface DummyOrderUserService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<DummyOrderUserVo> findByConditions(Pageable pageable, DummyOrderUserPaginationDto dto);

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  DummyOrderUserVo findDetailById(String id);

  /**
   * 创建
   *
   * @param dummyOrderUserVo
   * @return
   */
  DummyOrderUserVo create(DummyOrderUserVo dummyOrderUserVo);

  /**
   * 更新
   *
   * @param dummyOrderUserVo
   * @return
   */
  DummyOrderUserVo update(DummyOrderUserVo dummyOrderUserVo);

  /**
   * 按id集合启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 按id集合禁用
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 逻辑删除
   *
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);

  /**
   * 用户信息
   * @param orderCode
   * @return
   */
  List<DummyOrderUserVo> userInfoList(String orderCode);

  /**
   * 用户报名信息
   * @param pageable
   * @param paginationDto
   * @return
   */
  Page<DummyOrderApplyUserVo> findDummyOrderUserApplyByConditions(Pageable pageable, DummyOrderUserPaginationDto paginationDto);

  /**
   * 批量存虚拟订单报名信息
   * @param list
   */
  void batchSave(List<DummyOrderUserVo> list);
}
