package com.biz.crm.member.business.member.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.dto.IndustryDto;
import com.biz.crm.member.business.member.sdk.dto.IndustryPageDto;
import com.biz.crm.member.business.member.sdk.vo.IndustryPageVo;
import com.biz.crm.member.business.member.sdk.vo.IndustryVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 行业管理接口
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/12 16:19
 **/
public interface IndustryService {

    /**
     * 行业管理分页查询
     * @param pageable
     * @param pageDto
     * @return
     */
    Page<IndustryPageVo> findByConditions(Pageable pageable, IndustryPageDto pageDto);

    /**
     * 详情（根据id）
     * @param id
     * @return
     */
    IndustryVo findDetailById(String id);

    /**
     * 新增
     * @param industryDto
     * @return
     */
    IndustryVo create(IndustryDto industryDto);

    /**
     * 修改
     * @param industryDto
     * @return
     */
    IndustryVo update(IndustryDto industryDto);

    /**
     * 批量启用
     * @param ids
     */
    void enableBatch(List<String> ids);

    /**
     * 批量禁用
     * @param ids
     */
    void disableBatch(List<String> ids);

    /**
     * 批量删除
     * @param ids
     */
    void deleteBatch(List<String> ids);
}
