package com.biz.crm.member.business.member.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.dto.InfoCategoryDto;
import com.biz.crm.member.business.member.sdk.dto.InfoCategoryPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.InfoCategoryVo;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/16 10:58
 * @description 资讯分类管理
 */
public interface InfoCategoryService {

  /**
   * 新增一个资讯分类
   * @param infoCategoryDto
   * @return
   */
  InfoCategoryVo createInfoCategory(InfoCategoryDto infoCategoryDto);

  /**
   * 修改一个资讯分类信息
   * @param infoCategoryDto
   * @return
   */
  InfoCategoryVo updateInfoCategory(InfoCategoryDto infoCategoryDto);

  /**
   * 分页获取资讯分类信息
   * @param paginationDto
   * @return
   */
  Page<InfoCategoryVo> pageInfoCategory(Pageable pageable, InfoCategoryPaginationDto paginationDto);

  /**
   * 根据id获取资讯分类信息
   * @param id 资讯分类id
   * @return
   */
  InfoCategoryVo getInfoCategoryById(String id);

  /**
   * 根据id批量启用资讯分类
   * @param ids
   */
  void turnOnInfoCategory(List<String> ids);

  /**
   * 根据id批量禁用资讯分类
   * @param ids
   */
  void turnOffInfoCategory(List<String> ids);

  /**
   * 根据id批量逻辑删除资讯分类
   * @param ids
   */
  void logicDeleteInfoCategory(List<String> ids);

  /**
   * 小程序端根据应用范围获取有效的资讯分类
   * @param applyRange 应用范围,数据字典:mms_info_category
   * @return
   */
  List<InfoCategoryVo> appListEnableInfoCategoryByApplyRange(String applyRange);
}
