package com.biz.crm.member.business.member.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.dto.InfoManageDto;
import com.biz.crm.member.business.member.sdk.dto.InfoManagePaginationDto;
import com.biz.crm.member.business.member.sdk.dto.InfoManagePubDto;
import com.biz.crm.member.business.member.sdk.vo.InfoManageVo;
import java.util.Date;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/19 10:10
 * @description 资讯管理
 */
public interface InfoManageService {

  /**
   * 新增富文本类型的资讯管理
   * @param dto
   * @return
   */
  InfoManageVo createRichText(InfoManageDto dto);

  /**
   * 创建公众号类型的资讯
   * @return
   */
  InfoManageVo createPubAccount(InfoManagePubDto dto);

  /**
   * 根据id集合批量逻辑删除资讯
   * @param ids
   */
  void logicDeleteInfoByIds(List<String> ids);

  /**
   * 修改资讯信息
   * @param dto
   * @return
   */
  InfoManageVo updateInfo(InfoManageDto dto);

  /**
   * 根据id集合修改资讯状态为启用
   * @param ids
   */
  void turnOnInfoByIds(List<String> ids);

  /**
   * 根据id集合禁用资讯状态
   * @param ids
   */
  void turnOffByIds(List<String> ids);

  /**
   * 分页获取资讯
   * @param pageable
   * @param dto
   * @return
   */
  Page<InfoManageVo> pageInfo(Pageable pageable, InfoManagePaginationDto dto);

  /**
   * 小程序获取资讯精选模块的最新三个资讯信息
   * @return
   */
  List<InfoManageVo> getAppIndexInfoLimitThree();

  /**
   * 小程序获取资讯列表，根据应用模块查询(applyModel)和资讯分类(infoCategory)
   * 应用模块对应的数据字典是:mms_info_apply_model,枚举:InfoApplyModelEnum
   * @param pageable
   * @return
   */
  Page<InfoManageVo> pageInfoManageApp(Pageable pageable, String infoCategoryCode, String applyModel);

  /**
   * 为指定资讯增加一个阅读量
   * @param infoCode
   */
  void addInfoReadNum(String infoCode,  String modifyAccount, String modifyName, Date modifyTime);

  /**
   * 小程序获取资讯详情
   * 在此接口中增加资讯的阅读数量
   * @param infoCode
   * @return
   */
  InfoManageVo appGetInfoDetailByCode(String infoCode);

  /**
   * 小程序分享资讯
   * @param infoCode
   * @return
   */
  InfoManageVo appShareInfoByCode(String infoCode);

  /**
   * 获取所有，有效的，且分类是精选分类的，资讯信息
   * @return
   */
  List<InfoManageVo> listEnableChoiceNessCategoryInfo();

  /**
   * 小程序端根据精选分类编码获取最新的一个资讯
   * @param choiceCategoryCode
   * @return
   */
  InfoManageVo getInfoByChoiceCodeLast(String choiceCategoryCode);
}
