package com.biz.crm.member.business.member.local.service;

import com.biz.crm.member.business.member.local.entity.InfoUpvote;
import com.biz.crm.member.business.member.sdk.vo.InfoCountDto;
import java.util.List;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/19 16:19
 * @description 资讯点赞量管理
 */
public interface InfoUpvoteService {

  /**
   * 为指定资讯添加一条点赞数
   * @param infoCode
   */
  void addInfoUpvote(String infoCode);

  /**
   * 取消点赞
   * @param infoCode 资讯编码
   */
  void logicDeleteUpvote(String infoCode);

  /**
   * 统计点赞数
   * @param infoCode
   * @return
   */
  Integer countUpvoteByInfoCode(String infoCode);

  /**
   * 批量统计资讯点赞数
   * @param infoCodes
   * @return
   */
  List<InfoCountDto> countUpvoteByInfoCodes(List<String> infoCodes);

  /**
   * 根据资讯编码和会员编码获取点赞信息
   * @param infoCodes
   * @param memberCode
   * @return
   */
  List<InfoUpvote> listUpvoteInfoByMemberCodeAndInfoCodes(List<String> infoCodes, String memberCode);
}
