package com.biz.crm.member.business.member.local.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.local.entity.LabelCategory;
import com.biz.crm.member.business.member.sdk.dto.LabelCategoryDto;
import com.biz.crm.member.business.member.sdk.vo.LabelCategoryVo;
import java.util.List;
import org.springframework.data.domain.Pageable;

public interface LabelCategoryService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param labelCategoryVo
   * @return
   */
  Page<LabelCategoryVo> findByConditions(Pageable pageable,LabelCategoryVo labelCategoryVo);

  /**
   * 创建
   *
   * @param labelCategoryVo
   * @return
   */
  void create(LabelCategoryVo labelCategoryVo);

  /**
   * 更新
   *
   * @param labelCategoryVo
   * @return
   */
  void update(LabelCategoryVo labelCategoryVo);

  /**
   * 按id集合启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 按id集合禁用
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 逻辑删除
   *
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);

  /**
   * 下拉框
   */
  List<LabelCategoryVo> findByConditions();

  /**
   * 标签排序移动
   */
  void updateSort(String id,Integer sort);

  /**
   * 所有标签分类
   * @return
   */
  List<LabelCategoryVo> labelCategoryAll();

  /**
   * 所有标签根据分类分组
   * @param vo
   * @return
   */
  List<LabelCategoryVo> labelAll(LabelCategoryVo vo);
}
