package com.biz.crm.member.business.member.local.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.dto.LabelDetailDto;
import com.biz.crm.member.business.member.sdk.dto.LabelPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.LabelDetailVo;
import com.biz.crm.member.business.member.sdk.vo.LabelVo;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * @author hupan
 * @date 2023/6/13 17:32
 */
public interface LabelService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param labelPaginationDto
   * @return
   */
  Page<LabelVo> findByConditions(Pageable pageable, LabelPaginationDto labelPaginationDto);

  /**
   * 创建
   *
   * @param labelVo
   * @return
   */
  void create(LabelVo labelVo);

  /**
   * 更新
   *
   * @param labelVo
   * @return
   */
  void update(LabelVo labelVo);

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  LabelVo findDetailById(String id);

  /**
   * 按id集合启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 按id集合禁用
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 逻辑删除
   *
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);

}
