package com.biz.crm.member.business.member.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.vo.LevelManageBenefitsDetailVo;
import com.biz.crm.member.business.member.sdk.dto.LevelManageBenefitsDetailPaginationDto;
import java.util.List;
import java.util.Set;
import org.springframework.data.domain.Pageable;

/**
 * 等级管理-权益配置明细(LevelManageBenefitsDetail)表服务接口
 *
 * @author zouhs
 * @date 2023-06-13 09:52:24
 */
public interface LevelManageBenefitsDetailService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<LevelManageBenefitsDetailVo> findByConditions(Pageable pageable, LevelManageBenefitsDetailPaginationDto dto);

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  LevelManageBenefitsDetailVo findDetailById(String id);

  /**
   * 创建
   *
   * @param levelManageBenefitsDetailVo
   * @return
   */
  LevelManageBenefitsDetailVo create(LevelManageBenefitsDetailVo levelManageBenefitsDetailVo);

  /**
   * 更新
   *
   * @param levelManageBenefitsDetailVo
   * @return
   */
  LevelManageBenefitsDetailVo update(LevelManageBenefitsDetailVo levelManageBenefitsDetailVo);

  /**
   * 按id集合启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 按id集合禁用
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 逻辑删除
   *
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);

  /**
   * 批量新增权益明细
   * @param levelManageBenefitsDetailVos
   */
  void saveBatch(List<LevelManageBenefitsDetailVo> levelManageBenefitsDetailVos);

  /**
   * 查询列表
   * @param code
   * @return
   */
  List<LevelManageBenefitsDetailVo> findListDetailById(String levelCode,String code);

  /**
   * 真实删除
   * @param ids
   */
  void del(Set<String> ids);

  /**
   * 根据等级编码和权益分类
   * @param bLevelCodes
   * @param codes
   * @return
   */
  List<LevelManageBenefitsDetailVo> findListDetailByLevelCodeAndCode(Set<String> bLevelCodes, List<String> codes);
}
