package com.biz.crm.member.business.member.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.vo.LevelManageBenefitsVo;
import com.biz.crm.member.business.member.sdk.dto.LevelManageBenefitsPaginationDto;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * 等级管理-权益配置(LevelManageBenefits)表服务接口
 *
 * @author zouhs
 * @date 2023-06-13 09:52:00
 */
public interface LevelManageBenefitsService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<LevelManageBenefitsVo> findByConditions(Pageable pageable, LevelManageBenefitsPaginationDto dto);

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  LevelManageBenefitsVo findDetailById(String id);

  /**
   * 创建
   *
   * @param levelManageBenefitsVo
   * @return
   */
  LevelManageBenefitsVo create(LevelManageBenefitsVo levelManageBenefitsVo);

  /**
   * 更新
   *
   * @param levelManageBenefitsVo
   * @return
   */
  LevelManageBenefitsVo update(LevelManageBenefitsVo levelManageBenefitsVo);

  /**
   * 按id集合启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 按id集合禁用
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 逻辑删除
   *
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);

  /**
   * 查询
   * @param levelCode
   * @return
   */
  List<LevelManageBenefitsVo> findListDetailById(String levelCode);
}
