package com.biz.crm.member.business.member.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.vo.LevelManageVo;
import com.biz.crm.member.business.member.sdk.dto.LevelManagePaginationDto;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletLevelBenefitsVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletLevelManageVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletMemberHoneVo;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * 等级管理(LevelManage)表服务接口
 *
 * @author zouhs
 * @date 2023-06-13 09:51:36
 */
public interface LevelManageService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<LevelManageVo> findByConditions(Pageable pageable, LevelManagePaginationDto dto);

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  LevelManageVo findDetailById(String id);

  /**
   * 按memberCode查询详情
   *
   * @param levelCode
   * @return
   */
  LevelManageVo findDetailByLevelCode(String levelCode);


  /**
   * 创建
   *
   * @param levelManageVo
   * @return
   */
  LevelManageVo create(LevelManageVo levelManageVo);

  /**
   * 更新
   *
   * @param levelManageVo
   * @return
   */
  LevelManageVo update(LevelManageVo levelManageVo);

  /**
   * 按id集合启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 按id集合禁用
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 逻辑删除
   *
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);

  /**
   * 所有等级
   * @return
   */
  List<LevelManageVo> allList();

  /**
   * 查询下一等级
   * @param levelManageVo
   * @return
   */
  LevelManageVo nextLevelManage(LevelManageVo levelManageVo);

  /**
   * 查看所有等级
   * @param memberCode
   * @return
   */
  List<AppletLevelManageVo> getMemberLevelAll(String memberCode);

  /**
   * 查看指定会员等级及下所有等级信息
   * @param memberLevelCode
   * @return
   */
  List<AppletLevelManageVo> getAllChildrenIncludeMe(String memberLevelCode);

  /**
   * 会员等级权益信息列表
   * @param levelCode
   * @param memberCode
   * @return
   */
  List<AppletLevelBenefitsVo> getMemberBenefitsList(String levelCode, String memberCode);
}
