package com.biz.crm.member.business.member.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoArchivesVo;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoArchivesPaginationDto;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * 会员档案(MemberInfoArchives)表服务接口
 *
 * @author zouhs
 * @date 2023-06-19 14:32:22
 */
public interface MemberInfoArchivesService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<MemberInfoArchivesVo> findByConditions(Pageable pageable, MemberInfoArchivesPaginationDto dto);

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  MemberInfoArchivesVo findDetailById(String id);

  /**
   * 按id查询详情
   *
   * @param memberCode
   * @return
   */
  MemberInfoArchivesVo findDetailByMemberCode(String memberCode);

  /**
   * 创建
   *
   * @param memberInfoArchivesVo
   * @return
   */
  MemberInfoArchivesVo create(MemberInfoArchivesVo memberInfoArchivesVo);

  /**
   * 更新
   *
   * @param memberInfoArchivesVo
   * @return
   */
  MemberInfoArchivesVo update(MemberInfoArchivesVo memberInfoArchivesVo);

  /**
   * 按id集合启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 按id集合禁用
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 逻辑删除
   *
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);
}
