package com.biz.crm.member.business.member.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoAssetsVo;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoAssetsPaginationDto;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * 会员资产(MemberInfoAssets)表服务接口
 *
 * @author zouhs
 * @date 2023-06-19 14:32:52
 */
public interface MemberInfoAssetsService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<MemberInfoAssetsVo> findByConditions(Pageable pageable, MemberInfoAssetsPaginationDto dto);

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  MemberInfoAssetsVo findDetailById(String id);

  /**
   * 按memberCode查询详情
   *
   * @param memberCode
   * @return
   */
  MemberInfoAssetsVo findDetailByMemberCode(String memberCode);

  /**
   * 创建
   *
   * @param memberInfoAssetsVo
   * @return
   */
  MemberInfoAssetsVo create(MemberInfoAssetsVo memberInfoAssetsVo);

  /**
   * 更新
   *
   * @param memberInfoAssetsVo
   * @return
   */
  MemberInfoAssetsVo update(MemberInfoAssetsVo memberInfoAssetsVo);

  /**
   * 按id集合启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 按id集合禁用
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 逻辑删除
   *
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);
}
