package com.biz.crm.member.business.member.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.dto.BenefitsRecordPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoBenefitsVo;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoBenefitsPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletLevelBenefitsVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletMemberInfoBenefits;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletMemberInfoBenefitsReqVo;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * 会员权益关联表(MemberInfoBenefits)表服务接口
 *
 * @author zouhs
 * @date 2023-06-20 15:08:40
 */
public interface MemberInfoBenefitsService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<MemberInfoBenefitsVo> findByConditions(Pageable pageable, MemberInfoBenefitsPaginationDto dto);

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  MemberInfoBenefitsVo findDetailById(String id);

  /**
   * 创建
   *
   * @param memberInfoBenefitsVo
   * @return
   */
  MemberInfoBenefitsVo create(MemberInfoBenefitsVo memberInfoBenefitsVo);

  /**
   * 更新
   *
   * @param memberInfoBenefitsVo
   * @return
   */
  MemberInfoBenefitsVo update(MemberInfoBenefitsVo memberInfoBenefitsVo);

  /**
   * 按id集合启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 按id集合禁用
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 逻辑删除
   *
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);

  /**
   * 权益兑换列表
   * @param appletMemberInfoBenefitsReqVo
   * @return
   */
  Page<AppletMemberInfoBenefits> getMemberInfoBenefitsList(Pageable pageable,
      AppletMemberInfoBenefitsReqVo appletMemberInfoBenefitsReqVo);

  /**
   * 根据条件分页获取权限记录
   * @param pageable
   * @param dto
   * @return
   */
  Page<MemberInfoBenefitsVo> pageByConditions(Pageable pageable, BenefitsRecordPaginationDto dto);

  /**
   * 权益兑换详情
   * @param memberCode
   * @param id
   * @return
   */
  AppletMemberInfoBenefits getMemberInfoBenefitsDetailById(String memberCode, String id);

  /**
   * 权益兑换订单
   * @param appletMemberInfoBenefits
   * @return
   */
  AppletMemberInfoBenefits getMemberInfoBenefitsSubmit(AppletMemberInfoBenefits appletMemberInfoBenefits);
}
