package com.biz.crm.member.business.member.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.vo.GrowRecordAPIVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoComeBackRecordDetailVo;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoComeBackRecordDetailPaginationDto;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * 会员退货记录明细(MemberInfoComeBackRecordDetail)表服务接口
 *
 * @author zouhs
 * @date 2023-06-28 16:57:10
 */
public interface MemberInfoComeBackRecordDetailService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<MemberInfoComeBackRecordDetailVo> findByConditions(Pageable pageable, MemberInfoComeBackRecordDetailPaginationDto dto);

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  MemberInfoComeBackRecordDetailVo findDetailById(String id);

  /**
   * 创建
   *
   * @param memberInfoComeBackRecordDetailVo
   * @return
   */
  MemberInfoComeBackRecordDetailVo create(MemberInfoComeBackRecordDetailVo memberInfoComeBackRecordDetailVo);

  /**
   * 更新
   *
   * @param memberInfoComeBackRecordDetailVo
   * @return
   */
  MemberInfoComeBackRecordDetailVo update(MemberInfoComeBackRecordDetailVo memberInfoComeBackRecordDetailVo);

  /**
   * 按id集合启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 按id集合禁用
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 逻辑删除
   *
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);

  /**
   * 按照流水单编码查询
   * @param resourceDocumentCode
   */
  List<GrowRecordAPIVo> findDetailByResourceDocumentCode(String resourceDocumentCode);
}
