package com.biz.crm.member.business.member.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoComeBackRecordDetailVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoComeBackRecordVo;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoComeBackRecordPaginationDto;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * 会员退货记录(MemberInfoComeBackRecord)表服务接口
 *
 * @author zouhs
 * @date 2023-06-28 16:56:23
 */
public interface MemberInfoComeBackRecordService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<MemberInfoComeBackRecordVo> findByConditions(Pageable pageable, MemberInfoComeBackRecordPaginationDto dto);

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  MemberInfoComeBackRecordVo findDetailById(String id);

  /**
   * 创建
   *
   * @param memberInfoComeBackRecordVo
   * @return
   */
  MemberInfoComeBackRecordVo create(MemberInfoComeBackRecordVo memberInfoComeBackRecordVo);

  /**
   * 更新
   *
   * @param memberInfoComeBackRecordVo
   * @return
   */
  MemberInfoComeBackRecordVo update(MemberInfoComeBackRecordVo memberInfoComeBackRecordVo);

  /**
   * 按id集合启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 按id集合禁用
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 逻辑删除
   *
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);

  /**
   * 根据退货编码获取退货明细
   * @param comeBackCode
   * @return
   */
  List<MemberInfoComeBackRecordDetailVo> findDetailByComeBackCode(String comeBackCode);
}
