package com.biz.crm.member.business.member.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoContactVo;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoContactPaginationDto;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * 业务员联系人(MemberInfoContact)表服务接口
 *
 * @author zouhs
 * @date 2023-06-19 14:33:17
 */
public interface MemberInfoContactService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<MemberInfoContactVo> findByConditions(Pageable pageable, MemberInfoContactPaginationDto dto);

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  MemberInfoContactVo findDetailById(String id);

  /**
   * 创建
   *
   * @param memberInfoContactVo
   * @return
   */
  MemberInfoContactVo create(MemberInfoContactVo memberInfoContactVo);

  /**
   * 更新
   *
   * @param memberInfoContactVo
   * @return
   */
  MemberInfoContactVo update(MemberInfoContactVo memberInfoContactVo);

  /**
   * 按id集合启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 按id集合禁用
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 逻辑删除
   *
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);
}
