package com.biz.crm.member.business.member.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.dto.GrowRecordAPIPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.GrowRecordAPIVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoGrowRecordVo;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoGrowRecordPaginationDto;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * 会员成长值变动记录(MemberInfoGrowRecord)表服务接口
 *
 * @author zouhs
 * @date 2023-06-19 14:33:37
 */
public interface MemberInfoGrowRecordService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<MemberInfoGrowRecordVo> findByConditions(Pageable pageable, MemberInfoGrowRecordPaginationDto dto);

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  MemberInfoGrowRecordVo findDetailById(String id);

  /**
   * 创建
   *
   * @param memberInfoGrowRecordVo
   * @return
   */
  MemberInfoGrowRecordVo create(MemberInfoGrowRecordVo memberInfoGrowRecordVo);

  /**
   * 更新
   *
   * @param memberInfoGrowRecordVo
   * @return
   */
  MemberInfoGrowRecordVo update(MemberInfoGrowRecordVo memberInfoGrowRecordVo);

  /**
   * 按id集合启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 按id集合禁用
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 逻辑删除
   *
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);

  /**
   * 小程序成长值记录分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<GrowRecordAPIVo> findByConditionsAPI(Pageable pageable, GrowRecordAPIPaginationDto dto);

  /**
   * 详情
   *
   * @param vo
   * @return
   */
  List<GrowRecordAPIVo> findDetail(GrowRecordAPIVo vo);
}
