package com.biz.crm.member.business.member.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoIntegralRecordPaginationAPIDto;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoIntegralRecordAPIVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoIntegralRecordVo;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoIntegralRecordPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.MemberIntegralCountVo;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * 会员积分变动记录(MemberInfoIntegralRecord)表服务接口
 *
 * @author zouhs
 * @date 2023-06-19 14:34:02
 */
public interface MemberInfoIntegralRecordService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<MemberInfoIntegralRecordVo> findByConditions(Pageable pageable, MemberInfoIntegralRecordPaginationDto dto);

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  MemberInfoIntegralRecordVo findDetailById(String id);

  /**
   * 按code查询详情
   *
   * @param code
   * @return
   */
  MemberInfoIntegralRecordVo findDetailByCode(String code);

  /**
   * 创建
   *
   * @param memberInfoIntegralRecordVo
   * @return
   */
  MemberInfoIntegralRecordVo create(MemberInfoIntegralRecordVo memberInfoIntegralRecordVo);

  /**
   * 更新
   *
   * @param memberInfoIntegralRecordVo
   * @return
   */
  MemberInfoIntegralRecordVo update(MemberInfoIntegralRecordVo memberInfoIntegralRecordVo);

  /**
   * 按id集合启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 按id集合禁用
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 逻辑删除
   *
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);

  /**
   * 统一其他业务获取积分和扣减积分接口(收入,支出,扣减)
   * @param memberInfoIntegralRecordVo
   */
  void commonInternal(MemberInfoIntegralRecordVo memberInfoIntegralRecordVo);

  /**
   * 小程序分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */

  Page<MemberInfoIntegralRecordAPIVo> findByConditionsAPI(
      Pageable pageable, MemberInfoIntegralRecordPaginationAPIDto dto);

  /**
   * 小程序积分记录-当前积分和即将过期积分
   */
  MemberInfoIntegralRecordAPIVo initData(String memberCode);

  /**
   * 定时任务-每月1号的0:0:0查询本月即将过期的积分
   */
  void expiringSoon();

  /**
   * 后台统计积分
   * @return
   */
  MemberIntegralCountVo countIntegralRecord();
}
