package com.biz.crm.member.business.member.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoLevelChangeRecordVo;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoLevelChangeRecordPaginationDto;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * 会员等级变动记录(MemberInfoLevelChangeRecord)表服务接口
 *
 * @author zouhs
 * @date 2023-06-19 14:34:22
 */
public interface MemberInfoLevelChangeRecordService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<MemberInfoLevelChangeRecordVo> findByConditions(Pageable pageable, MemberInfoLevelChangeRecordPaginationDto dto);

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  MemberInfoLevelChangeRecordVo findDetailById(String id);

  /**
   * 按memberCode查询详情
   *
   * @param memberCode
   * @return
   */
  MemberInfoLevelChangeRecordVo findDetailByMemberCode(String memberCode);

  /**
   * 创建
   *
   * @param memberInfoLevelChangeRecordVo
   * @return
   */
  MemberInfoLevelChangeRecordVo create(MemberInfoLevelChangeRecordVo memberInfoLevelChangeRecordVo);

  /**
   * 更新
   *
   * @param memberInfoLevelChangeRecordVo
   * @return
   */
  MemberInfoLevelChangeRecordVo update(MemberInfoLevelChangeRecordVo memberInfoLevelChangeRecordVo);

  /**
   * 按id集合启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 按id集合禁用
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 逻辑删除
   *
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);
}
