package com.biz.crm.member.business.member.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.vo.GrowRecordAPIVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoReceiptRecordDetailVo;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoReceiptRecordDetailPaginationDto;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * 会员签收记录产品明细(MemberInfoReceiptRecordDetail)表服务接口
 *
 * @author zouhs
 * @date 2023-06-28 16:55:59
 */
public interface MemberInfoReceiptRecordDetailService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<MemberInfoReceiptRecordDetailVo> findByConditions(Pageable pageable, MemberInfoReceiptRecordDetailPaginationDto dto);

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  MemberInfoReceiptRecordDetailVo findDetailById(String id);

  /**
   * 创建
   *
   * @param memberInfoReceiptRecordDetailVo
   * @return
   */
  MemberInfoReceiptRecordDetailVo create(MemberInfoReceiptRecordDetailVo memberInfoReceiptRecordDetailVo);

  /**
   * 更新
   *
   * @param memberInfoReceiptRecordDetailVo
   * @return
   */
  MemberInfoReceiptRecordDetailVo update(MemberInfoReceiptRecordDetailVo memberInfoReceiptRecordDetailVo);

  /**
   * 按id集合启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 按id集合禁用
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 逻辑删除
   *
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);

  /**
   * 按照流水单编码查询
   * @param resourceDocumentCode
   */
  List<GrowRecordAPIVo> findDetailByResourceDocumentCode(String resourceDocumentCode);

  /**
   * 处理明细
   * @param list
   */
  void batchSave(List<MemberInfoReceiptRecordDetailVo> list);
}
