package com.biz.crm.member.business.member.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.vo.GrowRecordAPIVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoReceiptRecordDetailVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoReceiptRecordVo;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoReceiptRecordPaginationDto;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * 会员签收记录(MemberInfoReceiptRecord)表服务接口
 *
 * @author zouhs
 * @date 2023-06-28 16:55:37
 */
public interface MemberInfoReceiptRecordService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<MemberInfoReceiptRecordVo> findByConditions(Pageable pageable, MemberInfoReceiptRecordPaginationDto dto);

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  MemberInfoReceiptRecordVo findDetailById(String id);

  /**
   * 创建
   *
   * @param memberInfoReceiptRecordVo
   * @return
   */
  MemberInfoReceiptRecordVo create(MemberInfoReceiptRecordVo memberInfoReceiptRecordVo);

  /**
   * 更新
   *
   * @param memberInfoReceiptRecordVo
   * @return
   */
  MemberInfoReceiptRecordVo update(MemberInfoReceiptRecordVo memberInfoReceiptRecordVo);

  /**
   * 按id集合启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 按id集合禁用
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 逻辑删除
   *
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);

  /**
   * 根据单据编码获取签收产品明细
   * @param receiptCode
   * @return
   */
  List<MemberInfoReceiptRecordDetailVo> findDetailByReceiptCode(String receiptCode);
}
