package com.biz.crm.member.business.member.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoAllVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoAssetsVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoGrowRecordVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoIntegralRecordVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoVo;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.MemberLoginVo;
import com.biz.crm.member.business.member.sdk.vo.PersonalCenterAPIVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletMemberBaseInfoVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletMemberHoneVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletMemberInfoReqVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletMemberInfoVo;
import java.text.ParseException;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * 会员信息(MemberInfo)表服务接口
 *
 * @author zouhs
 * @date 2023-06-19 14:31:58
 */
public interface MemberInfoService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<MemberInfoVo> findByConditions(Pageable pageable, MemberInfoPaginationDto dto);

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  MemberInfoVo findDetailById(String id);

  /**
   * 按memberCode查询详情
   *
   * @param memberCode
   * @return
   */
  MemberInfoVo findDetailByMemberCode(String memberCode);

  /**
   * 按memberCode查询详情
   *
   * @param memberCode
   * @return
   */
  AppletMemberBaseInfoVo findBaseInfoByMemberCode(String memberCode);

  /**
   * 创建
   *
   * @param memberInfoVo
   * @return
   */
  MemberInfoVo create(MemberInfoVo memberInfoVo);

  /**
   * 更新
   *
   * @param memberInfoVo
   * @return
   */
  MemberInfoVo update(MemberInfoVo memberInfoVo);

  /**
   * 更新小程序基础信息
   *
   * @param appletMemberBaseInfoVo
   * @return
   */
  AppletMemberBaseInfoVo updateBase(AppletMemberBaseInfoVo appletMemberBaseInfoVo);

  /**
   * 按id集合启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 按id集合禁用
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 逻辑删除
   *
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);

  /**
   * 审批通过
   * @param memberInfoVo
   */
  void approvalPass(MemberInfoVo memberInfoVo);

  /**
   * 审批驳回
   * @param memberInfoVo
   */
  void approvalReject(MemberInfoVo memberInfoVo);

  /**
   * 维护行业
   * @param memberInfoVo
   */
  void maintainIndustry(MemberInfoVo memberInfoVo);

  /**
   * 维护部门
   * @param memberInfoVo
   */
  void maintainDepartment(MemberInfoVo memberInfoVo);

  /**
   * 基础资料
   * @param id
   * @return
   */
  MemberInfoAllVo findAllDetailById(String id);

  /**
   * 会员资产
   * @param id
   * @return
   */
  MemberInfoAssetsVo findAssetsDetailById(String id);

  /**
   * 修改积分
   * @param memberInfoIntegralRecordVo
   */
  void updateIntegral(MemberInfoIntegralRecordVo memberInfoIntegralRecordVo);

  /**
   * 修改成长值
   * @param memberInfoGrowRecordVo
   */
  void updateGrow(MemberInfoGrowRecordVo memberInfoGrowRecordVo);

  /**
   * 用户信息
   * @param phone
   * @return
   */
  MemberLoginVo queryMemberInfo(String phone);

  /**
   * 创建一个游客会员
   * @param phone
   * @return
   */
  MemberLoginVo createVisitorMember(String phone);

  /**
   * 查询会员关联信息
   * @param
   * @return
   */
  PersonalCenterAPIVo queryMemberAssociationInfo();

  /**
   * 查询会员关联信息
   * @param
   * @return
   */
  PersonalCenterAPIVo queryMemberAssociationInfoCard();

  /**
   * 小程序用户会员信息
   * @param memberCode
   * @return
   */
  AppletMemberInfoVo getMemberInfo(String memberCode);

  /**
   * 修改生日 - 只能修改一次
   * @param appletMemberInfoReqVo
   */
  void updMemberBirthday(AppletMemberInfoReqVo appletMemberInfoReqVo);

  /**
   * 会员信息我的
   * @param memberCode
   * @return
   */
  AppletMemberHoneVo getMemberHome(String memberCode);

  /**
   * 查询当前等级信息
   * @param memberCode
   * @return
   */
  AppletMemberHoneVo getMemberLevelInfo(String memberCode);

  /**
   * 定时任务-每天00:00:00根据会员生日做弹窗
   */
  void addPopupNotify();
}
