package com.biz.crm.member.business.member.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoSignVo;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoSignPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.MemberSignCountVo;
import com.biz.crm.member.business.member.sdk.vo.MemberSignRecordVo;
import com.biz.crm.member.business.member.sdk.vo.SignInfoVo;
import com.biz.crm.member.business.member.sdk.vo.SignResultVo;
import java.util.Date;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * 会员签到表(MemberInfoSign)表服务接口
 *
 * @author zouhs
 * @date 2023-06-27 13:44:50
 */
public interface MemberInfoSignService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<MemberInfoSignVo> findByConditions(Pageable pageable, MemberInfoSignPaginationDto dto);

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  MemberInfoSignVo findDetailById(String id);

  /**
   * 创建
   *
   * @param memberInfoSignVo
   * @return
   */
  MemberInfoSignVo create(MemberInfoSignVo memberInfoSignVo);

  /**
   * 更新
   *
   * @param memberInfoSignVo
   * @return
   */
  MemberInfoSignVo update(MemberInfoSignVo memberInfoSignVo);

  /**
   * 按id集合启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 按id集合禁用
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 逻辑删除
   *
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);

  /**
   * 统计发放积分
   * @return
   */
  MemberSignCountVo signCountNum();

  /**
   *
   * @param memberInfoSignPaginationDto
   * @return
   */
  MemberSignRecordVo querySignCountNum(MemberInfoSignPaginationDto memberInfoSignPaginationDto);

  /**
   * 小程序，获取当前用户本月的签到记录
   * @return
   */
  List<MemberInfoSignVo> listCurrentUserMemberInfoSign(String dateTime);

  /**
   * 小程序，获取当前登录用户本月的签到信息
   * @return
   */
  SignInfoVo getSignDetail(String dateTime);

  /**
   * 小程序签到
   * @return
   */
  SignResultVo appSign();
}
