package com.biz.crm.member.business.member.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoSupplyVo;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoSupplyPaginationDto;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * 采供关系(MemberInfoSupply)表服务接口
 *
 * @author zouhs
 * @date 2023-06-19 14:34:41
 */
public interface MemberInfoSupplyService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<MemberInfoSupplyVo> findByConditions(Pageable pageable, MemberInfoSupplyPaginationDto dto);

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  MemberInfoSupplyVo findDetailById(String id);

  /**
   * 创建
   *
   * @param memberInfoSupplyVo
   * @return
   */
  MemberInfoSupplyVo create(MemberInfoSupplyVo memberInfoSupplyVo);

  /**
   * 更新
   *
   * @param memberInfoSupplyVo
   * @return
   */
  MemberInfoSupplyVo update(MemberInfoSupplyVo memberInfoSupplyVo);

  /**
   * 按id集合启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 按id集合禁用
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 逻辑删除
   *
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);
}
