package com.biz.crm.member.business.member.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoTagVo;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoTagPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.MemberLabelUpdVo;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * 会员标签(MemberInfoTag)表服务接口
 *
 * @author zouhs
 * @date 2023-06-19 14:35:01
 */
public interface MemberInfoTagService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<MemberInfoTagVo> findByConditions(Pageable pageable, MemberInfoTagPaginationDto dto);

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  MemberInfoTagVo findDetailById(String id);

  /**
   * 创建
   *
   * @param memberInfoTagVo
   * @return
   */
  MemberInfoTagVo create(MemberInfoTagVo memberInfoTagVo);

  /**
   * 更新
   *
   * @param memberInfoTagVo
   * @return
   */
  MemberInfoTagVo update(MemberInfoTagVo memberInfoTagVo);

  /**
   * 按id集合启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 按id集合禁用
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 逻辑删除
   *
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);

  /**
   * 编辑保存更新标签
   * @param memberLabelUpdVo
   */
  void memberLabelUpd(MemberLabelUpdVo memberLabelUpdVo);

  /**
   * 会员标签
   * @param memberCode
   * @return
   */
  List<MemberInfoTagVo> queryMemberLabel(String memberCode);
}
