package com.biz.crm.member.business.member.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.dto.MessageManageDto;
import com.biz.crm.member.business.member.sdk.dto.MessageManagePageDto;
import com.biz.crm.member.business.member.sdk.vo.MessageManagePageVo;
import com.biz.crm.member.business.member.sdk.vo.MessageManageVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 消息弹窗配置接口
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/15 15:01
 **/
public interface MessageManageService {

    /**
     * 分页查询
     * @param pageable
     * @param pageDto
     * @return
     */
    Page<MessageManagePageVo> findByConditions(Pageable pageable, MessageManagePageDto pageDto);

    MessageManageVo findDetailById(String id);

    MessageManageVo create(MessageManageDto messageManageDto);

    MessageManageVo update(MessageManageDto messageManageDto);

    void enableBatch(List<String> ids);

    void disableBatch(List<String> ids);

    void deleteBatch(List<String> ids);

}
