package com.biz.crm.member.business.member.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.sdk.dto.ProductDto;
import com.biz.crm.member.business.member.sdk.dto.ProductPageDto;
import com.biz.crm.member.business.member.sdk.vo.ProductPageVo;
import com.biz.crm.member.business.member.sdk.vo.ProductVo;
import org.springframework.data.domain.Pageable;

import java.math.BigDecimal;
import java.util.List;

/**
 * TODO
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/13 16:50
 **/
public interface ProductService {

    /**
     * 分页查询
     * @param pageable
     * @param pageDto
     * @return
     */
    Page<ProductPageVo> findByConditions(Pageable pageable, ProductPageDto pageDto);

    /**
     * 详情
     * @param id
     * @return
     */
    ProductVo findDetailById(String id);

    /**
     * 新增
     * @param productDto
     * @return
     */
    ProductVo create(ProductDto productDto);

    /**
     * 修改
     * @param productDto
     * @return
     */
    ProductVo update(ProductDto productDto);

    /**
     * 批量禁用
     * @param ids
     */
    void disableBatch(List<String> ids);

    /**
     * 批量上架
     * @param ids
     */
    void shelfUp(List<String> ids);

    /**
     * 批量下架
     * @param ids
     */
    void shelfDown(List<String> ids);

    /**
     * 批量启用
     * @param ids
     */
    void enableBatch(List<String> ids);

    void deleteBatch(List<String> ids);

    /**
     * 调整数量
     * @param id
     * @param number
     */
    void adjust(String id, BigDecimal number);
}
