package com.biz.crm.member.business.member.local.service;

import com.biz.crm.member.business.member.local.entity.Questionnaire;
import com.biz.crm.member.business.member.local.entity.QuestionnaireQuestion;
import com.biz.crm.member.business.member.sdk.dto.QuestionDto;
import com.biz.crm.member.business.member.sdk.dto.QuestionnaireQuestionDto;
import com.biz.crm.member.business.member.sdk.vo.QuestionCountVo;
import com.biz.crm.member.business.member.sdk.vo.QuestionVo;
import java.util.List;
import java.util.Map;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/20 15:38
 * @description 问卷答题配置管理
 */
public interface QuestionnaireQuestionService {

  /**
   * 为指定问卷添加题目配置
   * @param dtoList
   */
  void createQuestion(List<QuestionnaireQuestionDto> dtoList, String questionnaireCode);

  /**
   * 根据问卷编码获取题目配置信息
   * 根据sortIndex升序排序
   * @param questionnaireCode
   * @return
   */
  List<QuestionVo> listByQuestionnaireCodeOrderBySortIndex(String questionnaireCode);

  /**
   * 根据问卷编码逻辑删除题目
   * @param questionnaireCode
   */
  void logicDeleteByQuestionnaireCode(String questionnaireCode);

  /**
   * 根据题目编码获取题目详情
   * @return
   */
  QuestionnaireQuestion getQuestionInfoByCode(String questionCode);
}
